<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\CsvImportTrait;
use App\Http\Requests\MassDestroySchTeacherRequest;
use App\Http\Requests\StoreSchTeacherRequest;
use App\Http\Requests\UpdateSchTeacherRequest;
use App\Models\SchSubject;
use App\Models\SchTeacher;
use Gate;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class SchTeacherController extends Controller
{
    use CsvImportTrait;

    public function index()
    {
        abort_if(Gate::denies('sch_teacher_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $schTeachers = SchTeacher::with(['schsubjects'])->get();
         $schTeachers = SchTeacher::with(['schsubjects.sch_class'])->get();

        return view('admin.schTeachers.index', compact('schTeachers'));
    }

    public function create()
    {
        abort_if(Gate::denies('sch_teacher_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        /* $schsubjects = SchSubject::pluck('name', 'id'); */
        // Отримуємо предмети разом із класами
        $schsubjects = SchSubject::with('sch_class')->get()->mapWithKeys(function ($item) {
            return [
                $item->id => $item->name . ' (' . ($item->sch_class->name ?? '') . ')'
            ];
        });

        return view('admin.schTeachers.create', compact('schsubjects'));
    }

    public function store(StoreSchTeacherRequest $request)
    {
        $data = $request->all();
        $data['user_id'] = auth()->id(); // Записуємо ID поточного користувача

        $schTeacher = SchTeacher::create($data);
        $schTeacher = SchTeacher::create($request->all());
        $schTeacher->schsubjects()->sync($request->input('schsubjects', []));

        
        return redirect()->route('admin.sch-teachers.index')->with('success', 'Учитель успішно створений!');
    }

    public function edit(SchTeacher $schTeacher)
    {
        abort_if(Gate::denies('sch_teacher_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        /* $schsubjects = SchSubject::pluck('name', 'id'); */

        // Отримуємо предмети разом із класами
        $schsubjects = SchSubject::with('sch_class')->get()->mapWithKeys(function ($item) {
            return [
                $item->id => $item->name . ' (' . ($item->sch_class->name ?? '') . ')'
            ];
        });

        $schTeacher->load('schsubjects');

        return view('admin.schTeachers.edit', compact('schTeacher', 'schsubjects'));
    }


    /*     public function edit(SchTeacher $schTeacher)
    {
        abort_if(Gate::denies('sch_teacher_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $schsubjects = SchSubject::pluck('name', 'id');

        $schTeacher->load('schsubjects');

        return view('admin.schTeachers.edit', compact('schTeacher', 'schsubjects'));
    } */

    public function update(UpdateSchTeacherRequest $request, SchTeacher $schTeacher)
    {
        $data = $request->all();
        $data['user_id'] = auth()->id(); // Записуємо ID поточного користувача

        $schTeacher->update($data);

        $schTeacher->update($request->all());
        $schTeacher->schsubjects()->sync($request->input('schsubjects', []));

        return redirect()->route('admin.sch-teachers.index')->with('success', 'Дані учителя успішно оновлені!');
    }

    public function show(SchTeacher $schTeacher)
    {
        abort_if(Gate::denies('sch_teacher_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $schTeacher->load('schsubjects', 'schteacherSchReports');

        return view('admin.schTeachers.show', compact('schTeacher'));
    }

    public function destroy(SchTeacher $schTeacher)
    {
        abort_if(Gate::denies('sch_teacher_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $schTeacher->delete();

        return back();
    }

    public function massDestroy(MassDestroySchTeacherRequest $request)
    {
        $schTeachers = SchTeacher::find(request('ids'));

        foreach ($schTeachers as $schTeacher) {
            $schTeacher->delete();
        }

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
