<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\CsvImportTrait;
use App\Http\Requests\MassDestroyUserRequest;
use App\Http\Requests\StoreUserRequest;
use App\Http\Requests\UpdateUserRequest;
use App\Models\Role;
use App\Models\Team;
use App\Models\User;
use App\Models\SchTeacher;
use Gate;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class UsersController extends Controller
{
    use CsvImportTrait;

    public function index()
    {
        abort_if(Gate::denies('user_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $users = User::with(['roles', 'team'])->get();

        return view('admin.users.index', compact('users'));
    }

    public function create()
    {
        abort_if(Gate::denies('user_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');


        $roles = Role::pluck('title', 'id');

        $teams = Team::pluck('name', 'id')->prepend(trans('global.pleaseSelect'), '');

        return view('admin.users.create', compact('roles', 'teams'));
    }

    public function store(StoreUserRequest $request)
    {
        $data = $request->all();
        $data['name_ua'] = trim($data['name_teacher'] . ' ' . $data['last_name_teacher']);
        $data['name_en'] = trim($data['name_teacher_en'] . ' ' . $data['last_name_teacher_en']);

        $user = User::create($data);
        $user->roles()->sync($request->input('roles', []));

        // Перевірка наявності запису в таблиці sch_teachers
        $schTeacher = SchTeacher::where('user_id', $user->id)->first();
        if ($schTeacher) {
            // Оновлення запису
            $schTeacher->update([
                'name_ua' => $data['name_ua'],
                'name_en' => $data['name_en'],

            ]);
        } else {
            // Створення нового запису
            SchTeacher::create([
                'name_ua' => $data['name_ua'],
                'name_en' => $data['name_en'],
                'user_id' => $user->id,
            ]);
        }

        return redirect()->route('admin.users.index')->with('success', 'Користувач успішно створений!');
    }

    /*     public function store(StoreUserRequest $request)
    {
        $user = User::create($request->all());
        $user->roles()->sync($request->input('roles', []));

        return redirect()->route('admin.users.index');
    } */

    public function edit(User $user)
    {
        abort_if(Gate::denies('user_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $roles = Role::pluck('title', 'id');

        $teams = Team::pluck('name', 'id')->prepend(trans('global.pleaseSelect'), '');

        $user->load('roles', 'team');

        return view('admin.users.edit', compact('roles', 'teams', 'user'));
    }

    public function update(UpdateUserRequest $request, User $user)
    {
        $data = $request->all();
        $data['name_ua'] = trim($data['name_teacher'] . ' ' . $data['last_name_teacher']);
        $data['name_en'] = trim($data['name_teacher_en'] . ' ' . $data['last_name_teacher_en']);

        $user->update($data);
        $user->roles()->sync($request->input('roles', []));

        // Перевірка наявності запису в таблиці sch_teachers
        $schTeacher = SchTeacher::where('user_id', $user->id)->first();
        if ($schTeacher) {
            // Оновлення запису
            $schTeacher->update([
                'name_ua' => $data['name_ua'],
                'name_en' => $data['name_en'],
                'user_id' => $user->id,
            ]);
        } else {
            // Створення нового запису
            SchTeacher::create([
                'name_ua' => $data['name_ua'],
                'name_en' => $data['name_en'],
                'user_id' => $user->id,
            ]);
        }

        return redirect()->route('admin.users.index')->with('success', 'Користувач успішно оновлений!');
    }

    public function show(User $user)
    {
        abort_if(Gate::denies('user_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $user->load('roles', 'team');

        return view('admin.users.show', compact('user'));
    }

    public function destroy(User $user)
    {
        abort_if(Gate::denies('user_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $user->delete();

        return back();
    }

    public function massDestroy(MassDestroyUserRequest $request)
    {
        $users = User::find(request('ids'));

        foreach ($users as $user) {
            $user->delete();
        }

        return response(null, Response::HTTP_NO_CONTENT);
    }

    protected static function booted()
    {
        static::saving(function ($user) {
            $user->name_ua = trim($user->name_teacher . ' ' . $user->last_name_teacher);
            $user->name_en = trim($user->name_teacher_en . ' ' . $user->last_name_teacher_en);
        });
    }
}
