<?php

namespace App\Models;

use DateTimeInterface;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SchClass extends Model
{
    use SoftDeletes, HasFactory;

    public $table = 'sch_classes';

    protected $dates = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected $fillable = [
        'name',
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }

    public function schClassSchSubjects()
    {
        return $this->hasMany(SchSubject::class, 'sch_class_id', 'id');
    }

    public function schstudents()
    {
        return $this->belongsToMany(Schstudent::class);
    }

    public function schClassSchStudents()
    {
        return $this->hasMany(SchClassSchStudent::class, 'sch_class_id', 'id');
    }
}
