<?php

namespace App\Models;

use DateTimeInterface;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SchSubject extends Model
{
    use SoftDeletes, HasFactory;

    public $table = 'sch_subjects';

    protected $dates = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected $fillable = [
        'name',
        'sch_class_id',
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }

    public function schsubjectSchReports()
    {
        return $this->hasMany(SchReport::class, 'schsubject_id', 'id');
    }

    public function schsubjectSchTeachers()
    {
        return $this->belongsToMany(SchTeacher::class);
    }

    public function sch_class()
    {
        return $this->belongsTo(SchClass::class, 'sch_class_id');
    }

    public function schclass()
    {
        return $this->belongsTo(SchClass::class, 'sch_class_id');
    }
}
