{{-- filepath: c:\OSPanel1\domains\i.liko-crm2\resources\views\admin\schReports\class_list.blade.php --}}
@extends('layouts.admin')
@section('content')
    <div class="card">
        <div class="card-header">
            Список класів
        </div>
        <div class="card-body">
            <table class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>Клас</th>
                        <th>Дії</th>

                    </tr>
                </thead>
                <tbody>
                    @foreach ($schclasses as $class)
                        <tr>
                            <td>{{ $class->name }}</td>
                            <td>
                                <button class="btn btn-xs btn-primary toggle-students" data-class-id="{{ $class->id }}">
                                    Показати учнів
                                </button>
                            </td>
                        </tr>
                        <tr class="students-row" id="students-{{ $class->id }}" style="display: none;">
                            <td colspan="2">
                                <div class="loading-spinner" id="loading-{{ $class->id }}" style="display: none;">
                                    Завантаження...
                                </div>
                                <table class="table table-sm">
                                    <thead>
                                        <tr>
                                            <th>Учень</th>
                                            <th>Дії</th>
                                            <th>Репорти</th>
                                        </tr>
                                    </thead>
                                    <tbody id="students-list-{{ $class->id }}">
                                        {{-- Список учнів буде завантажено через AJAX --}}
                                    </tbody>
                                </table>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    <!-- Modal -->
    <div class="modal fade" id="reportsModal" tabindex="-1" aria-labelledby="reportsModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="reportsModalLabel">Репорти учня</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Закрити"></button>
                </div>
                <div class="modal-body" id="reports-modal-body">
                    <!-- Тут буде список репортів і форма -->
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const toggleButtons = document.querySelectorAll('.toggle-students');
            toggleButtons.forEach(button => {
                button.addEventListener('click', function() {
                    const classId = this.dataset.classId;
                    const row = document.getElementById(`students-${classId}`);
                    const spinner = document.getElementById(`loading-${classId}`);
                    const studentsList = document.getElementById(`students-list-${classId}`);

                    if (row.style.display === 'none') {
                        row.style.display = '';
                        spinner.style.display = 'block';

                        // Виконуємо AJAX-запит для отримання списку учнів
                        fetch(`/admin/class-list/get-class-data?class_id=${classId}`)
                            .then(response => {
                                if (!response.ok) {
                                    throw new Error(`HTTP error! status: ${response.status}`);
                                }
                                return response.json();
                            })
                            .then(data => {
                                spinner.style.display = 'none';
                                studentsList.innerHTML = '';

                                if (data.error) {
                                    studentsList.innerHTML =
                                        `<tr><td colspan="2">${data.error}</td></tr>`;
                                } else {
                                    // Додаємо приховане поле з предметами
                                    const hiddenSubjects = `
                                        <input type="hidden" name="subjects" value='${JSON.stringify(data.subjects)}'>
                                    `;
                                    studentsList.innerHTML += hiddenSubjects;

                                    data.students.forEach(student => {
                                        const studentRow = `
                                        <tr>
                                            <td>${student.name}</td>
                                            <td>
                                                <form method="POST" action="{{ route('admin.sch-reports.store') }}">
                                                    <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                                    <input type="hidden" name="class_id" value="${classId}">
                                                    <input type="hidden" name="student_id" value="${student.id}">
                                                    <input type="hidden" name="teacher_id" value="1">
                                                    <button type="button" class="btn btn-xs btn-success open-reports-modal"
                                                            data-student-id="${student.id}" data-class-id="${classId}">
                                                        Репорти
                                                    </button>
                                                </form>
                                            </td>
                                            <td>
                                                ${student.reports_count > 0
                                                    ? `<span class="badge bg-success">${student.reports_count} репорт(и)</span>`
                                                    : `<span class="badge bg-secondary">Немає репортів</span>`}
                                            </td>
                                        </tr>
                                        `;
                                        studentsList.innerHTML += studentRow;
                                    });
                                }
                            })
                            .catch(error => {
                                console.error('Помилка завантаження учнів:', error);
                                spinner.style.display = 'none';
                                studentsList.innerHTML =
                                    `<tr><td colspan="2">Помилка завантаження даних</td></tr>`;
                            });
                    } else {
                        row.style.display = 'none';
                    }
                });
            });
            // Делегування події для динамічних кнопок
            document.body.addEventListener('click', function(e) {
                if (e.target.classList.contains('open-reports-modal')) {
                    const studentId = e.target.getAttribute('data-student-id');
                    const classId = e.target.getAttribute('data-class-id');
                    openReportsModal(studentId, classId);
                }
            });

            function openReportsModal(studentId, classId) {
                // Завантаження репортів AJAX-ом
                fetch(`/admin/class-list/student-reports?student_id=${studentId}&class_id=${classId}`)
                    .then(response => response.text())
                    .then(html => {
                        document.getElementById('reports-modal-body').innerHTML = html;
                        let modal = new bootstrap.Modal(document.getElementById('reportsModal'));
                        modal.show();
                    });
            }
        });
    </script>
@endsection
