@extends('layouts.admin')
@section('content')
    <div class="card">
        <div class="card-header">
            {{ trans('global.create') }} {{ trans('cruds.schReport.title_singular') }}
        </div>

        <div class="card-body">
            <form method="POST" action="{{ route('admin.sch-reports.store') }}" enctype="multipart/form-data">
                @csrf

                <input type="text" name="class_id" value="{{ $classId }}">
                <div class="form-group">
                    <label for="schclass_id">{{ trans('cruds.schReport.fields.schclass') }}</label>
                    <select class="form-control select2 {{ $errors->has('schclass') ? 'is-invalid' : '' }}" name="schclass_id"
                        id="schclass_id">
                        @foreach ($schclasses as $id => $entry)
                            <option value="{{ $id }}" {{ old('schclass_id') == $id ? 'selected' : '' }}>
                                {{ $entry }}</option>
                        @endforeach
                    </select>
                    @if ($errors->has('schclass'))
                        <div class="invalid-feedback">
                            {{ $errors->first('schclass') }}
                        </div>
                    @endif
                    <span class="help-block">{{ trans('cruds.schReport.fields.schclass_helper') }}</span>
                </div>
                <div class="form-group">
                    <label for="schstudent_id">{{ trans('cruds.schReport.fields.schstudent') }}</label>
                    <select class="form-control select2 {{ $errors->has('schstudent') ? 'is-invalid' : '' }}"
                        name="schstudent_id" id="schstudent_id">
                        @foreach ($schstudents as $id => $entry)
                            <option value="{{ $id }}" {{ old('schstudent_id') == $id ? 'selected' : '' }}>
                                {{ $entry }}</option>
                        @endforeach
                    </select>
                    @if ($errors->has('schstudent'))
                        <div class="invalid-feedback">
                            {{ $errors->first('schstudent') }}
                        </div>
                    @endif
                    <span class="help-block">{{ trans('cruds.schReport.fields.schstudent_helper') }}</span>
                </div>
                <div class="form-group">
                    <label for="schteacher_id">{{ trans('cruds.schReport.fields.schteacher') }}</label>
                    <select class="form-control select2 {{ $errors->has('schteacher') ? 'is-invalid' : '' }}"
                        name="schteacher_id" id="schteacher_id">
                        @foreach ($schteachers as $id => $entry)
                            <option value="{{ $id }}" {{ old('schteacher_id') == $id ? 'selected' : '' }}>
                                {{ $entry }}</option>
                        @endforeach
                    </select>
                    @if ($errors->has('schteacher'))
                        <div class="invalid-feedback">
                            {{ $errors->first('schteacher') }}
                        </div>
                    @endif
                    <span class="help-block">{{ trans('cruds.schReport.fields.schteacher_helper') }}</span>
                </div>
                <div class="form-group">
                    <label for="schsubject_id">{{ trans('cruds.schReport.fields.schsubject') }}</label>
                    <select class="form-control select2 {{ $errors->has('schsubject') ? 'is-invalid' : '' }}"
                        name="schsubject_id" id="schsubject_id">
                        @foreach ($schsubjects as $id => $entry)
                            <option value="{{ $id }}" {{ old('schsubject_id') == $id ? 'selected' : '' }}>
                                {{ $entry }}</option>
                        @endforeach
                    </select>
                    @if ($errors->has('schsubject'))
                        <div class="invalid-feedback">
                            {{ $errors->first('schsubject') }}
                        </div>
                    @endif
                    <span class="help-block">{{ trans('cruds.schReport.fields.schsubject_helper') }}</span>
                </div>
                <div class="form-group">
                    <label for="report">{{ trans('cruds.schReport.fields.report') }}</label>
                    <textarea class="form-control {{ $errors->has('report') ? 'is-invalid' : '' }}" name="report" id="report">{{ old('report') }}</textarea>
                    @if ($errors->has('report'))
                        <div class="invalid-feedback">
                            {{ $errors->first('report') }}
                        </div>
                    @endif
                    <span class="help-block">{{ trans('cruds.schReport.fields.report_helper') }}</span>
                </div>
                <div class="form-group">
                    <label for="report_en">{{ trans('cruds.schReport.fields.report_en') }}</label>
                    <textarea class="form-control {{ $errors->has('report_en') ? 'is-invalid' : '' }}" name="report_en" id="report_en">{{ old('report_en') }}</textarea>
                    @if ($errors->has('report_en'))
                        <div class="invalid-feedback">
                            {{ $errors->first('report_en') }}
                        </div>
                    @endif
                    <span class="help-block">{{ trans('cruds.schReport.fields.report_en_helper') }}</span>
                </div>
                <div class="form-group">
                    <button class="btn btn-danger" type="submit">
                        {{ trans('global.save') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
@endsection

@section('scripts')
{{-- filepath: c:\OSPanel1\domains\i.liko-crm2\resources\views\admin\schReports\create.blade.php --}}
@push('scripts')
<script>
$(document).ready(function() {
    $('#schclass_id').on('change', function() {
        let classId = $(this).val();
        if (!classId) {
            $('#schstudent_id').empty();
            $('#schteacher_id').empty();
            $('#schsubject_id').empty();
            return;
        }
        $.ajax({
            url: '{{ route("admin.sch-reports.getClassData") }}',
            type: 'GET',
            data: { class_id: classId },
            success: function(data) {
                // Оновлюємо учнів
                $('#schstudent_id').empty();
                Object.entries(data.students)
                    .sort((a, b) => a[1].localeCompare(b[1]))
                    .forEach(([key, value]) => {
                        $('#schstudent_id').append('<option value="' + key + '">' + value + '</option>');
                    });

                // Оновлюємо вчителів
                $('#schteacher_id').empty();
                Object.entries(data.teachers)
                    .sort((a, b) => a[1].localeCompare(b[1]))
                    .forEach(([key, value]) => {
                        $('#schteacher_id').append('<option value="' + key + '">' + value + '</option>');
                    });

                // Оновлюємо предмети
                $('#schsubject_id').empty();
                Object.entries(data.subjects)
                    .sort((a, b) => a[1].localeCompare(b[1]))
                    .forEach(([key, value]) => {
                        $('#schsubject_id').append('<option value="' + key + '">' + value + '</option>');
                    });

                // Якщо використовуєте select2, оновіть його:
                $('#schstudent_id').trigger('change');
                $('#schteacher_id').trigger('change');
                $('#schsubject_id').trigger('change');
            }
        });
    });
});
</script>
@endpush
@endsection
