@extends('layouts.admin')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.create') }} {{ trans('cruds.schSubject.title_singular') }}
    </div>

    <div class="card-body">
        <form method="POST" action="{{ route("admin.sch-subjects.store") }}" enctype="multipart/form-data">
            @csrf
            <div class="form-group">
                <label for="name">{{ trans('cruds.schSubject.fields.name') }}</label>
                <input class="form-control {{ $errors->has('name') ? 'is-invalid' : '' }}" type="text" name="name" id="name" value="{{ old('name', '') }}">
                @if($errors->has('name'))
                    <div class="invalid-feedback">
                        {{ $errors->first('name') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.schSubject.fields.name_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="sch_class_id">{{ trans('cruds.schSubject.fields.sch_class') }}</label>
                <select class="form-control select2 {{ $errors->has('sch_class') ? 'is-invalid' : '' }}" name="sch_class_id" id="sch_class_id">
                    @foreach($sch_classes as $id => $entry)
                        <option value="{{ $id }}" {{ old('sch_class_id') == $id ? 'selected' : '' }}>{{ $entry }}</option>
                    @endforeach
                </select>
                @if($errors->has('sch_class'))
                    <div class="invalid-feedback">
                        {{ $errors->first('sch_class') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.schSubject.fields.sch_class_helper') }}</span>
            </div>
            <div class="form-group">
                <button class="btn btn-danger" type="submit">
                    {{ trans('global.save') }}
                </button>
            </div>
        </form>
    </div>
</div>



@endsection