@extends('layouts.admin')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.show') }} {{ trans('cruds.schTeacher.title') }}
    </div>

    <div class="card-body">
        <div class="form-group">
            <div class="form-group">
                <a class="btn btn-default" href="{{ route('admin.sch-teachers.index') }}">
                    {{ trans('global.back_to_list') }}
                </a>
            </div>
            <table class="table table-bordered table-striped">
                <tbody>
                    <tr>
                        <th>
                            {{ trans('cruds.schTeacher.fields.id') }}
                        </th>
                        <td>
                            {{ $schTeacher->id }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.schTeacher.fields.name_ua') }}
                        </th>
                        <td>
                            {{ $schTeacher->name_ua }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.schTeacher.fields.name_en') }}
                        </th>
                        <td>
                            {{ $schTeacher->name_en }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.schTeacher.fields.schsubject') }}
                        </th>
                        <td>
                            @foreach($schTeacher->schsubjects as $key => $schsubject)
                                <span class="label label-info">{{ $schsubject->name }}</span>
                            @endforeach
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.schTeacher.fields.userid') }}
                        </th>
                        <td>
                            {{ $schTeacher->userid }}
                        </td>
                    </tr>
                </tbody>
            </table>
            <div class="form-group">
                <a class="btn btn-default" href="{{ route('admin.sch-teachers.index') }}">
                    {{ trans('global.back_to_list') }}
                </a>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        {{ trans('global.relatedData') }}
    </div>
    <ul class="nav nav-tabs" role="tablist" id="relationship-tabs">
        <li class="nav-item">
            <a class="nav-link" href="#schteacher_sch_reports" role="tab" data-toggle="tab">
                {{ trans('cruds.schReport.title') }}
            </a>
        </li>
    </ul>
    <div class="tab-content">
        <div class="tab-pane" role="tabpanel" id="schteacher_sch_reports">
            @includeIf('admin.schTeachers.relationships.schteacherSchReports', ['schReports' => $schTeacher->schteacherSchReports])
        </div>
    </div>
</div>

@endsection