@extends('layouts.admin')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.edit') }} {{ trans('cruds.user.title_singular') }}
    </div>

    <div class="card-body">
        <form method="POST" action="{{ route("admin.users.update", [$user->id]) }}" enctype="multipart/form-data">
            @method('PUT')
            @csrf
            <div class="form-group">
                <label class="required" for="name">{{ trans('cruds.user.fields.name') }}</label>
                <input class="form-control {{ $errors->has('name') ? 'is-invalid' : '' }}" type="text" name="name" id="name" value="{{ old('name', $user->name) }}" required>
                @if($errors->has('name'))
                    <div class="invalid-feedback">
                        {{ $errors->first('name') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.user.fields.name_helper') }}</span>
            </div>
            <div class="form-group">
                <label class="required" for="email">{{ trans('cruds.user.fields.email') }}</label>
                <input class="form-control {{ $errors->has('email') ? 'is-invalid' : '' }}" type="email" name="email" id="email" value="{{ old('email', $user->email) }}" required>
                @if($errors->has('email'))
                    <div class="invalid-feedback">
                        {{ $errors->first('email') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.user.fields.email_helper') }}</span>
            </div>
            <div class="form-group">
                <label class="required" for="password">{{ trans('cruds.user.fields.password') }}</label>
                <input class="form-control {{ $errors->has('password') ? 'is-invalid' : '' }}" type="password" name="password" id="password">
                @if($errors->has('password'))
                    <div class="invalid-feedback">
                        {{ $errors->first('password') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.user.fields.password_helper') }}</span>
            </div>
            <div class="form-group">
                <label class="required" for="roles">{{ trans('cruds.user.fields.roles') }}</label>
                <div style="padding-bottom: 4px">
                    <span class="btn btn-info btn-xs select-all" style="border-radius: 0">{{ trans('global.select_all') }}</span>
                    <span class="btn btn-info btn-xs deselect-all" style="border-radius: 0">{{ trans('global.deselect_all') }}</span>
                </div>
                <select class="form-control select2 {{ $errors->has('roles') ? 'is-invalid' : '' }}" name="roles[]" id="roles" multiple required>
                    @foreach($roles as $id => $role)
                        <option value="{{ $id }}" {{ (in_array($id, old('roles', [])) || $user->roles->contains($id)) ? 'selected' : '' }}>{{ $role }}</option>
                    @endforeach
                </select>
                @if($errors->has('roles'))
                    <div class="invalid-feedback">
                        {{ $errors->first('roles') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.user.fields.roles_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="name_teacher">{{ trans('cruds.user.fields.name_teacher') }}</label>
                <input class="form-control {{ $errors->has('name_teacher') ? 'is-invalid' : '' }}" type="text" name="name_teacher" id="name_teacher" value="{{ old('name_teacher', $user->name_teacher) }}">
                @if($errors->has('name_teacher'))
                    <div class="invalid-feedback">
                        {{ $errors->first('name_teacher') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.user.fields.name_teacher_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="last_name_teacher">{{ trans('cruds.user.fields.last_name_teacher') }}</label>
                <input class="form-control {{ $errors->has('last_name_teacher') ? 'is-invalid' : '' }}" type="text" name="last_name_teacher" id="last_name_teacher" value="{{ old('last_name_teacher', $user->last_name_teacher) }}">
                @if($errors->has('last_name_teacher'))
                    <div class="invalid-feedback">
                        {{ $errors->first('last_name_teacher') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.user.fields.last_name_teacher_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="name_teacher_en">{{ trans('cruds.user.fields.name_teacher_en') }}</label>
                <input class="form-control {{ $errors->has('name_teacher_en') ? 'is-invalid' : '' }}" type="text" name="name_teacher_en" id="name_teacher_en" value="{{ old('name_teacher_en', $user->name_teacher_en) }}">
                @if($errors->has('name_teacher_en'))
                    <div class="invalid-feedback">
                        {{ $errors->first('name_teacher_en') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.user.fields.name_teacher_en_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="last_name_teacher_en">{{ trans('cruds.user.fields.last_name_teacher_en') }}</label>
                <input class="form-control {{ $errors->has('last_name_teacher_en') ? 'is-invalid' : '' }}" type="text" name="last_name_teacher_en" id="last_name_teacher_en" value="{{ old('last_name_teacher_en', $user->last_name_teacher_en) }}">
                @if($errors->has('last_name_teacher_en'))
                    <div class="invalid-feedback">
                        {{ $errors->first('last_name_teacher_en') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.user.fields.last_name_teacher_en_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="team_id">{{ trans('cruds.user.fields.team') }}</label>
                <select class="form-control select2 {{ $errors->has('team') ? 'is-invalid' : '' }}" name="team_id" id="team_id">
                    @foreach($teams as $id => $entry)
                        <option value="{{ $id }}" {{ (old('team_id') ? old('team_id') : $user->team->id ?? '') == $id ? 'selected' : '' }}>{{ $entry }}</option>
                    @endforeach
                </select>
                @if($errors->has('team'))
                    <div class="invalid-feedback">
                        {{ $errors->first('team') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.user.fields.team_helper') }}</span>
            </div>
            <div class="form-group">
                <button class="btn btn-danger" type="submit">
                    {{ trans('global.save') }}
                </button>
            </div>
        </form>
    </div>
</div>



@endsection