<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\CsvImportTrait;
use App\Http\Requests\MassDestroyPsihologAnketumRequest;
use App\Http\Requests\StorePsihologAnketumRequest;
use App\Http\Requests\UpdatePsihologAnketumRequest;
use App\Models\CrmCustomer;
use App\Models\PsihologAnketum;
use App\Models\User;
use Gate;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class PsihologAnketaController extends Controller
{
    use CsvImportTrait;

    public function index()
    {
        abort_if(Gate::denies('psiholog_anketum_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $psihologAnketa = PsihologAnketum::with(['name_childe', 'name_psyholog'])->get();

        return view('admin.psihologAnketa.index', compact('psihologAnketa'));
    }

    public function create()
    {
        abort_if(Gate::denies('psiholog_anketum_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $name_childes = CrmCustomer::pluck('first_name', 'id')->prepend(trans('global.pleaseSelect'), '');

        $name_psyhologs = User::pluck('name', 'id')->prepend(trans('global.pleaseSelect'), '');

        return view('admin.psihologAnketa.create', compact('name_childes', 'name_psyhologs'));
    }

    public function store(StorePsihologAnketumRequest $request)
    {
        $psihologAnketum = PsihologAnketum::create($request->all());

        return redirect()->route('admin.psiholog-anketa.index');
    }

    public function edit(PsihologAnketum $psihologAnketum)
    {
        abort_if(Gate::denies('psiholog_anketum_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $name_childes = CrmCustomer::pluck('first_name', 'id')->prepend(trans('global.pleaseSelect'), '');

        $name_psyhologs = User::pluck('name', 'id')->prepend(trans('global.pleaseSelect'), '');

        $psihologAnketum->load('name_childe', 'name_psyholog');

        return view('admin.psihologAnketa.edit', compact('name_childes', 'name_psyhologs', 'psihologAnketum'));
    }

    public function update(UpdatePsihologAnketumRequest $request, PsihologAnketum $psihologAnketum)
    {
        $psihologAnketum->update($request->all());

        return redirect()->route('admin.psiholog-anketa.index');
    }

    public function show(PsihologAnketum $psihologAnketum)
    {
        abort_if(Gate::denies('psiholog_anketum_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $psihologAnketum->load('name_childe', 'name_psyholog');

        return view('admin.psihologAnketa.show', compact('psihologAnketum'));
    }

    public function destroy(PsihologAnketum $psihologAnketum)
    {
        abort_if(Gate::denies('psiholog_anketum_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $psihologAnketum->delete();

        return back();
    }

    public function massDestroy(MassDestroyPsihologAnketumRequest $request)
    {
        $psihologAnketa = PsihologAnketum::find(request('ids'));

        foreach ($psihologAnketa as $psihologAnketum) {
            $psihologAnketum->delete();
        }

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
