<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\CsvImportTrait;
use App\Http\Requests\MassDestroySchstudentRequest;
use App\Http\Requests\StoreSchstudentRequest;
use App\Http\Requests\UpdateSchstudentRequest;
use App\Models\Schstudent;
use Gate;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class SchstudentController extends Controller
{
    use CsvImportTrait;

    public function index()
    {
        abort_if(Gate::denies('schstudent_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $schstudents = Schstudent::all();

        return view('admin.schstudents.index', compact('schstudents'));
    }

    public function create()
    {
        abort_if(Gate::denies('schstudent_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.schstudents.create');
    }

    public function store(StoreSchstudentRequest $request)
    {
        $schstudent = Schstudent::create($request->all());

        return redirect()->route('admin.schstudents.index');
    }

    public function edit(Schstudent $schstudent)
    {
        abort_if(Gate::denies('schstudent_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.schstudents.edit', compact('schstudent'));
    }

    public function update(UpdateSchstudentRequest $request, Schstudent $schstudent)
    {
        $schstudent->update($request->all());

        return redirect()->route('admin.schstudents.index');
    }

    public function show(Schstudent $schstudent)
    {
        abort_if(Gate::denies('schstudent_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $schstudent->load('schstudentSchReports', 'schstudentSchClasses');

        return view('admin.schstudents.show', compact('schstudent'));
    }

    public function destroy(Schstudent $schstudent)
    {
        abort_if(Gate::denies('schstudent_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $schstudent->delete();

        return back();
    }

    public function massDestroy(MassDestroySchstudentRequest $request)
    {
        $schstudents = Schstudent::find(request('ids'));

        foreach ($schstudents as $schstudent) {
            $schstudent->delete();
        }

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
