<?php

namespace App\Http\Requests;

use App\Models\SchClass;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class StoreSchClassRequest extends FormRequest
{
    public function authorize()
    {
        return Gate::allows('sch_class_create');
    }

    public function rules()
    {
        return [
            'name' => [
                'string',
                'nullable',
            ],
            'schstudents.*' => [
                'integer',
            ],
            'schstudents' => [
                'array',
            ],
        ];
    }
}
