<?php

namespace App\Models;

use Carbon\Carbon;
use DateTimeInterface;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PsihologAnketum extends Model
{
    use SoftDeletes, HasFactory;

    public $table = 'psiholog_anketa';

    protected $dates = [
        'date',
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    public const READING_TEMPO_RADIO = [
        '1'   => 'швидко',
        '0.5' => 'повільно',
    ];

    public const READING_RADIO = [
        '1'   => 'Читає',
        '0.5' => 'Знеає букви',
        '0'   => 'Не читає',
    ];

    public const MOTIVATION_TO_STUDY_RADIO = [
        '0'   => 'Ігровий',
        '0.5' => 'Соціальний',
        '1'   => 'Пізнавальний',
    ];

    public const CONCLUSION_SELECT = [
        '1'   => 'рекомендовано',
        '0.5' => 'рекомендовано із зауваженнями',
        '0'   => 'не рекомендовано',
    ];

    public const WAY_OF_READING_RADIO = [
        '1' => 'відривними складами',
        '2' => 'плавними складами',
        '3' => 'склад + слово',
        '4' => 'цілими словами',
    ];

    public const LOGICAL_LINES_RADIO = [
        '1'   => 'Дитина правильно називає предмет за аналогією. Може пояснити свій вибір',
        '0.5' => 'Дитина називає предмет за аналогією, але не може пояснити або за допомогою дорослого',
        '0'   => 'Дитина не правильно називає предмет або відмовляється виконувати завдання',
    ];

    public const FOURTH_IS_REDUNDANT_RADIO = [
        '1'   => 'Дитина правильно називає ознаки предметів, об\'єднує їх в групи за спільною суттєвою ознакою, виділяє четвертого зайвого і пояснює свій вибір',
        '0.5' => 'Дитина правильно називає чєтвертого зайвого. Але не пояснює свій вибір або групує за допомогою дорослого',
        '0'   => 'Дитина не називає самостійно чєтвертого зайвого або відмовляєтья від виконання завдання',
    ];

    public const NEBYLICI_RADIO = [
        '7' => 'Самостійно знаходить всі помилки (2хв) і дає обгрунтовану відповідь. Описує за допопмогою речень (простих, складних), правильно будує речення; з гумором реагує на на зображення',
        '5' => 'Самостійно знаходить помилки, але неповністю пояснює',
        '4' => 'Не всі знаходить помилки, деякі з них не може пояснити; з допомогою знаходить помилки',
        '2' => 'Знаходить 2 помилки і неможе їх пояснити',
        '0' => 'Відмовляється знаходити помилки',
    ];

    protected $fillable = [
        'name_childe_id',
        'date',
        'name_psyholog_id',
        'nebylici',
        'visual_memory',
        'reading',
        'auditory_memory',
        'fourth_is_redundant',
        'logical_lines',
        'social_readiness',
        'social_readiness_2',
        'social_readiness_3',
        'social_readiness_4',
        'social_readiness_5',
        'social_readiness_6',
        'social_readiness_7',
        'self_regulation',
        'self_regulation_2',
        'self_regulation_3',
        'self_regulation_4',
        'self_regulation_5',
        'self_regulation_6',
        'self_regulation_7',
        'self_regulation_8',
        'self_regulation_9',
        'motivation_to_study',
        'speech_physiology',
        'speech_physiology_2',
        'speech_physiology_3',
        'speech_physiology_4',
        'speech_physiology_5',
        'speech_physiology_6',
        'speech_physiology_7',
        'speech_physiology_8',
        'physiology_0',
        'physiology',
        'physiology_2',
        'physiology_3',
        'physiology_4',
        'reading_tempo',
        'way_of_reading',
        'fish',
        'fish_2',
        'fish_3',
        'fish_4',
        'copying_figures',
        'copying_figures_2',
        'copying_figures_3',
        'interview',
        'conclusion',
        'behavior',
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }

    public function name_childe()
    {
        return $this->belongsTo(CrmCustomer::class, 'name_childe_id');
    }

    public function getDateAttribute($value)
    {
        return $value ? Carbon::parse($value)->format(config('panel.date_format')) : null;
    }

    public function setDateAttribute($value)
    {
        $this->attributes['date'] = $value ? Carbon::createFromFormat(config('panel.date_format'), $value)->format('Y-m-d') : null;
    }

    public function name_psyholog()
    {
        return $this->belongsTo(User::class, 'name_psyholog_id');
    }
}
