<?php

namespace App\Models;

use DateTimeInterface;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SchTeacher extends Model
{
    use SoftDeletes, HasFactory;

    public $table = 'sch_teachers';

    protected $dates = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected $fillable = [
        'name_ua',
        'name_en',
        'user_id',
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }

    public function schteacherSchReports()
    {
        return $this->hasMany(SchReport::class, 'schteacher_id', 'id');
    }

    /*     public function schsubjects()
    {
        return $this->belongsToMany(SchSubject::class);
    } */
    public function schsubjects()
    {
        return $this->belongsToMany(SchSubject::class, 'sch_subject_sch_teacher', 'sch_teacher_id', 'sch_subject_id');
    }
}
