<?php

namespace App\Models;

use DateTimeInterface;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Schstudent extends Model
{
    use SoftDeletes, HasFactory;

    public $table = 'schstudents';

    protected $dates = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected $fillable = [
        'name_ua',
        'name_en',
        'userid',
        'schclass_id',
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }

    public function schstudentSchReports()
    {
        return $this->hasMany(SchReport::class, 'schstudent_id', 'id');
    }

    public function schstudentSchClasses()
    {
        return $this->belongsToMany(SchClass::class);
    }
    public function schclasses()
    {
        return $this->belongsToMany(SchClass::class);
    }
    public function schClassSchStudents()
    {
        return $this->hasMany(SchClassSchStudent::class, 'schstudent_id', 'id');
    }
}
