<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePsihologAnketaTable extends Migration
{
    public function up()
    {
        Schema::create('psiholog_anketa', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->date('date');
            $table->string('nebylici')->nullable();
            $table->float('visual_memory')->nullable();
            $table->string('reading')->nullable();
            $table->float('auditory_memory')->nullable();
            $table->string('fourth_is_redundant')->nullable();
            $table->string('logical_lines')->nullable();
            $table->boolean('social_readiness')->default(0)->nullable();
            $table->boolean('social_readiness_2')->default(0)->nullable();
            $table->boolean('social_readiness_3')->default(0)->nullable();
            $table->boolean('social_readiness_4')->default(0)->nullable();
            $table->boolean('social_readiness_5')->default(0)->nullable();
            $table->boolean('social_readiness_6')->default(0)->nullable();
            $table->boolean('social_readiness_7')->default(0)->nullable();
            $table->boolean('self_regulation')->default(0)->nullable();
            $table->boolean('self_regulation_2')->default(0)->nullable();
            $table->boolean('self_regulation_3')->default(0)->nullable();
            $table->boolean('self_regulation_4')->default(0)->nullable();
            $table->boolean('self_regulation_5')->default(0)->nullable();
            $table->boolean('self_regulation_6')->default(0)->nullable();
            $table->boolean('self_regulation_7')->default(0)->nullable();
            $table->boolean('self_regulation_8')->default(0)->nullable();
            $table->boolean('self_regulation_9')->default(0)->nullable();
            $table->string('motivation_to_study')->nullable();
            $table->boolean('speech_physiology')->default(0)->nullable();
            $table->boolean('speech_physiology_2')->default(0)->nullable();
            $table->boolean('speech_physiology_3')->default(0)->nullable();
            $table->boolean('speech_physiology_4')->default(0)->nullable();
            $table->boolean('speech_physiology_5')->default(0)->nullable();
            $table->boolean('speech_physiology_6')->default(0)->nullable();
            $table->boolean('speech_physiology_7')->default(0)->nullable();
            $table->boolean('speech_physiology_8')->default(0)->nullable();
            $table->boolean('physiology_0')->default(0)->nullable();
            $table->boolean('physiology')->default(0)->nullable();
            $table->boolean('physiology_2')->default(0)->nullable();
            $table->boolean('physiology_3')->default(0)->nullable();
            $table->boolean('physiology_4')->default(0)->nullable();
            $table->string('reading_tempo')->nullable();
            $table->string('way_of_reading')->nullable();
            $table->boolean('fish')->default(0)->nullable();
            $table->boolean('fish_2')->default(0)->nullable();
            $table->boolean('fish_3')->default(0)->nullable();
            $table->boolean('fish_4')->default(0)->nullable();
            $table->boolean('copying_figures')->default(0)->nullable();
            $table->boolean('copying_figures_2')->default(0)->nullable();
            $table->boolean('copying_figures_3')->default(0)->nullable();
            $table->integer('interview')->nullable();
            $table->string('conclusion')->nullable();
            $table->longText('behavior')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }
}
