@extends('layouts.admin')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.edit') }} {{ trans('cruds.crmCustomer.title_singular') }}
    </div>

    <div class="card-body">
        <form method="POST" action="{{ route("admin.crm-customers.update", [$crmCustomer->id]) }}" enctype="multipart/form-data">
            @method('PUT')
            @csrf
            <div class="form-group">
                <label class="required" for="first_name">{{ trans('cruds.crmCustomer.fields.first_name') }}</label>
                <input class="form-control {{ $errors->has('first_name') ? 'is-invalid' : '' }}" type="text" name="first_name" id="first_name" value="{{ old('first_name', $crmCustomer->first_name) }}" required>
                @if($errors->has('first_name'))
                    <div class="invalid-feedback">
                        {{ $errors->first('first_name') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.crmCustomer.fields.first_name_helper') }}</span>
            </div>
            <div class="form-group">
                <label class="required" for="date">{{ trans('cruds.crmCustomer.fields.date') }}</label>
                <input class="form-control date {{ $errors->has('date') ? 'is-invalid' : '' }}" type="text" name="date" id="date" value="{{ old('date', $crmCustomer->date) }}" required>
                @if($errors->has('date'))
                    <div class="invalid-feedback">
                        {{ $errors->first('date') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.crmCustomer.fields.date_helper') }}</span>
            </div>
            <div class="form-group">
                <label class="required" for="name_parent">{{ trans('cruds.crmCustomer.fields.name_parent') }}</label>
                <input class="form-control {{ $errors->has('name_parent') ? 'is-invalid' : '' }}" type="text" name="name_parent" id="name_parent" value="{{ old('name_parent', $crmCustomer->name_parent) }}" required>
                @if($errors->has('name_parent'))
                    <div class="invalid-feedback">
                        {{ $errors->first('name_parent') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.crmCustomer.fields.name_parent_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="past_educational_institution">{{ trans('cruds.crmCustomer.fields.past_educational_institution') }}</label>
                <input class="form-control {{ $errors->has('past_educational_institution') ? 'is-invalid' : '' }}" type="text" name="past_educational_institution" id="past_educational_institution" value="{{ old('past_educational_institution', $crmCustomer->past_educational_institution) }}">
                @if($errors->has('past_educational_institution'))
                    <div class="invalid-feedback">
                        {{ $errors->first('past_educational_institution') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.crmCustomer.fields.past_educational_institution_helper') }}</span>
            </div>
            <div class="form-group">
                <label class="required" for="warfare">{{ trans('cruds.crmCustomer.fields.warfare') }}</label>
                <input class="form-control {{ $errors->has('warfare') ? 'is-invalid' : '' }}" type="text" name="warfare" id="warfare" value="{{ old('warfare', $crmCustomer->warfare) }}" required>
                @if($errors->has('warfare'))
                    <div class="invalid-feedback">
                        {{ $errors->first('warfare') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.crmCustomer.fields.warfare_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="status_id">{{ trans('cruds.crmCustomer.fields.status') }}</label>
                <select class="form-control select2 {{ $errors->has('status') ? 'is-invalid' : '' }}" name="status_id" id="status_id">
                    @foreach($statuses as $id => $entry)
                        <option value="{{ $id }}" {{ (old('status_id') ? old('status_id') : $crmCustomer->status->id ?? '') == $id ? 'selected' : '' }}>{{ $entry }}</option>
                    @endforeach
                </select>
                @if($errors->has('status'))
                    <div class="invalid-feedback">
                        {{ $errors->first('status') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.crmCustomer.fields.status_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="pib_another_child_in_liko">{{ trans('cruds.crmCustomer.fields.pib_another_child_in_liko') }}</label>
                <input class="form-control {{ $errors->has('pib_another_child_in_liko') ? 'is-invalid' : '' }}" type="text" name="pib_another_child_in_liko" id="pib_another_child_in_liko" value="{{ old('pib_another_child_in_liko', $crmCustomer->pib_another_child_in_liko) }}">
                @if($errors->has('pib_another_child_in_liko'))
                    <div class="invalid-feedback">
                        {{ $errors->first('pib_another_child_in_liko') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.crmCustomer.fields.pib_another_child_in_liko_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="email">{{ trans('cruds.crmCustomer.fields.email') }}</label>
                <input class="form-control {{ $errors->has('email') ? 'is-invalid' : '' }}" type="text" name="email" id="email" value="{{ old('email', $crmCustomer->email) }}">
                @if($errors->has('email'))
                    <div class="invalid-feedback">
                        {{ $errors->first('email') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.crmCustomer.fields.email_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="phone">{{ trans('cruds.crmCustomer.fields.phone') }}</label>
                <input class="form-control {{ $errors->has('phone') ? 'is-invalid' : '' }}" type="text" name="phone" id="phone" value="{{ old('phone', $crmCustomer->phone) }}">
                @if($errors->has('phone'))
                    <div class="invalid-feedback">
                        {{ $errors->first('phone') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.crmCustomer.fields.phone_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="address">{{ trans('cruds.crmCustomer.fields.address') }}</label>
                <input class="form-control {{ $errors->has('address') ? 'is-invalid' : '' }}" type="text" name="address" id="address" value="{{ old('address', $crmCustomer->address) }}">
                @if($errors->has('address'))
                    <div class="invalid-feedback">
                        {{ $errors->first('address') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.crmCustomer.fields.address_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="description">{{ trans('cruds.crmCustomer.fields.description') }}</label>
                <textarea class="form-control {{ $errors->has('description') ? 'is-invalid' : '' }}" name="description" id="description">{{ old('description', $crmCustomer->description) }}</textarea>
                @if($errors->has('description'))
                    <div class="invalid-feedback">
                        {{ $errors->first('description') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.crmCustomer.fields.description_helper') }}</span>
            </div>
            <div class="form-group">
                <button class="btn btn-danger" type="submit">
                    {{ trans('global.save') }}
                </button>
            </div>
        </form>
    </div>
</div>



@endsection