@extends('layouts.admin')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.show') }} {{ trans('cruds.psihologAnketum.title') }}
    </div>

    <div class="card-body">
        <div class="form-group">
            <div class="form-group">
                <a class="btn btn-default" href="{{ route('admin.psiholog-anketa.index') }}">
                    {{ trans('global.back_to_list') }}
                </a>
            </div>
            <table class="table table-bordered table-striped">
                <tbody>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.id') }}
                        </th>
                        <td>
                            {{ $psihologAnketum->id }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.name_childe') }}
                        </th>
                        <td>
                            {{ $psihologAnketum->name_childe->first_name ?? '' }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.date') }}
                        </th>
                        <td>
                            {{ $psihologAnketum->date }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.name_psyholog') }}
                        </th>
                        <td>
                            {{ $psihologAnketum->name_psyholog->name ?? '' }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.nebylici') }}
                        </th>
                        <td>
                            {{ App\Models\PsihologAnketum::NEBYLICI_RADIO[$psihologAnketum->nebylici] ?? '' }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.visual_memory') }}
                        </th>
                        <td>
                            {{ $psihologAnketum->visual_memory }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.reading') }}
                        </th>
                        <td>
                            {{ App\Models\PsihologAnketum::READING_RADIO[$psihologAnketum->reading] ?? '' }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.auditory_memory') }}
                        </th>
                        <td>
                            {{ $psihologAnketum->auditory_memory }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.fourth_is_redundant') }}
                        </th>
                        <td>
                            {{ App\Models\PsihologAnketum::FOURTH_IS_REDUNDANT_RADIO[$psihologAnketum->fourth_is_redundant] ?? '' }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.logical_lines') }}
                        </th>
                        <td>
                            {{ App\Models\PsihologAnketum::LOGICAL_LINES_RADIO[$psihologAnketum->logical_lines] ?? '' }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.social_readiness') }}
                        </th>
                        <td>
                            <input type="checkbox" disabled="disabled" {{ $psihologAnketum->social_readiness ? 'checked' : '' }}>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.social_readiness_2') }}
                        </th>
                        <td>
                            <input type="checkbox" disabled="disabled" {{ $psihologAnketum->social_readiness_2 ? 'checked' : '' }}>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.social_readiness_3') }}
                        </th>
                        <td>
                            <input type="checkbox" disabled="disabled" {{ $psihologAnketum->social_readiness_3 ? 'checked' : '' }}>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.social_readiness_4') }}
                        </th>
                        <td>
                            <input type="checkbox" disabled="disabled" {{ $psihologAnketum->social_readiness_4 ? 'checked' : '' }}>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.social_readiness_5') }}
                        </th>
                        <td>
                            <input type="checkbox" disabled="disabled" {{ $psihologAnketum->social_readiness_5 ? 'checked' : '' }}>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.social_readiness_6') }}
                        </th>
                        <td>
                            <input type="checkbox" disabled="disabled" {{ $psihologAnketum->social_readiness_6 ? 'checked' : '' }}>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.social_readiness_7') }}
                        </th>
                        <td>
                            <input type="checkbox" disabled="disabled" {{ $psihologAnketum->social_readiness_7 ? 'checked' : '' }}>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.self_regulation') }}
                        </th>
                        <td>
                            <input type="checkbox" disabled="disabled" {{ $psihologAnketum->self_regulation ? 'checked' : '' }}>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.self_regulation_2') }}
                        </th>
                        <td>
                            <input type="checkbox" disabled="disabled" {{ $psihologAnketum->self_regulation_2 ? 'checked' : '' }}>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.self_regulation_3') }}
                        </th>
                        <td>
                            <input type="checkbox" disabled="disabled" {{ $psihologAnketum->self_regulation_3 ? 'checked' : '' }}>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.self_regulation_4') }}
                        </th>
                        <td>
                            <input type="checkbox" disabled="disabled" {{ $psihologAnketum->self_regulation_4 ? 'checked' : '' }}>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.self_regulation_5') }}
                        </th>
                        <td>
                            <input type="checkbox" disabled="disabled" {{ $psihologAnketum->self_regulation_5 ? 'checked' : '' }}>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.self_regulation_6') }}
                        </th>
                        <td>
                            <input type="checkbox" disabled="disabled" {{ $psihologAnketum->self_regulation_6 ? 'checked' : '' }}>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.self_regulation_7') }}
                        </th>
                        <td>
                            <input type="checkbox" disabled="disabled" {{ $psihologAnketum->self_regulation_7 ? 'checked' : '' }}>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.self_regulation_8') }}
                        </th>
                        <td>
                            <input type="checkbox" disabled="disabled" {{ $psihologAnketum->self_regulation_8 ? 'checked' : '' }}>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.self_regulation_9') }}
                        </th>
                        <td>
                            <input type="checkbox" disabled="disabled" {{ $psihologAnketum->self_regulation_9 ? 'checked' : '' }}>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.motivation_to_study') }}
                        </th>
                        <td>
                            {{ App\Models\PsihologAnketum::MOTIVATION_TO_STUDY_RADIO[$psihologAnketum->motivation_to_study] ?? '' }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.speech_physiology') }}
                        </th>
                        <td>
                            <input type="checkbox" disabled="disabled" {{ $psihologAnketum->speech_physiology ? 'checked' : '' }}>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.speech_physiology_2') }}
                        </th>
                        <td>
                            <input type="checkbox" disabled="disabled" {{ $psihologAnketum->speech_physiology_2 ? 'checked' : '' }}>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.speech_physiology_3') }}
                        </th>
                        <td>
                            <input type="checkbox" disabled="disabled" {{ $psihologAnketum->speech_physiology_3 ? 'checked' : '' }}>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.speech_physiology_4') }}
                        </th>
                        <td>
                            <input type="checkbox" disabled="disabled" {{ $psihologAnketum->speech_physiology_4 ? 'checked' : '' }}>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.speech_physiology_5') }}
                        </th>
                        <td>
                            <input type="checkbox" disabled="disabled" {{ $psihologAnketum->speech_physiology_5 ? 'checked' : '' }}>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.speech_physiology_6') }}
                        </th>
                        <td>
                            <input type="checkbox" disabled="disabled" {{ $psihologAnketum->speech_physiology_6 ? 'checked' : '' }}>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.speech_physiology_7') }}
                        </th>
                        <td>
                            <input type="checkbox" disabled="disabled" {{ $psihologAnketum->speech_physiology_7 ? 'checked' : '' }}>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.speech_physiology_8') }}
                        </th>
                        <td>
                            <input type="checkbox" disabled="disabled" {{ $psihologAnketum->speech_physiology_8 ? 'checked' : '' }}>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.physiology_0') }}
                        </th>
                        <td>
                            <input type="checkbox" disabled="disabled" {{ $psihologAnketum->physiology_0 ? 'checked' : '' }}>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.physiology') }}
                        </th>
                        <td>
                            <input type="checkbox" disabled="disabled" {{ $psihologAnketum->physiology ? 'checked' : '' }}>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.physiology_2') }}
                        </th>
                        <td>
                            <input type="checkbox" disabled="disabled" {{ $psihologAnketum->physiology_2 ? 'checked' : '' }}>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.physiology_3') }}
                        </th>
                        <td>
                            <input type="checkbox" disabled="disabled" {{ $psihologAnketum->physiology_3 ? 'checked' : '' }}>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.physiology_4') }}
                        </th>
                        <td>
                            <input type="checkbox" disabled="disabled" {{ $psihologAnketum->physiology_4 ? 'checked' : '' }}>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.reading_tempo') }}
                        </th>
                        <td>
                            {{ App\Models\PsihologAnketum::READING_TEMPO_RADIO[$psihologAnketum->reading_tempo] ?? '' }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.way_of_reading') }}
                        </th>
                        <td>
                            {{ App\Models\PsihologAnketum::WAY_OF_READING_RADIO[$psihologAnketum->way_of_reading] ?? '' }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.fish') }}
                        </th>
                        <td>
                            <input type="checkbox" disabled="disabled" {{ $psihologAnketum->fish ? 'checked' : '' }}>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.fish_2') }}
                        </th>
                        <td>
                            <input type="checkbox" disabled="disabled" {{ $psihologAnketum->fish_2 ? 'checked' : '' }}>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.fish_3') }}
                        </th>
                        <td>
                            <input type="checkbox" disabled="disabled" {{ $psihologAnketum->fish_3 ? 'checked' : '' }}>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.fish_4') }}
                        </th>
                        <td>
                            <input type="checkbox" disabled="disabled" {{ $psihologAnketum->fish_4 ? 'checked' : '' }}>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.copying_figures') }}
                        </th>
                        <td>
                            <input type="checkbox" disabled="disabled" {{ $psihologAnketum->copying_figures ? 'checked' : '' }}>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.copying_figures_2') }}
                        </th>
                        <td>
                            <input type="checkbox" disabled="disabled" {{ $psihologAnketum->copying_figures_2 ? 'checked' : '' }}>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.copying_figures_3') }}
                        </th>
                        <td>
                            <input type="checkbox" disabled="disabled" {{ $psihologAnketum->copying_figures_3 ? 'checked' : '' }}>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.interview') }}
                        </th>
                        <td>
                            {{ $psihologAnketum->interview }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.conclusion') }}
                        </th>
                        <td>
                            {{ App\Models\PsihologAnketum::CONCLUSION_SELECT[$psihologAnketum->conclusion] ?? '' }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.psihologAnketum.fields.behavior') }}
                        </th>
                        <td>
                            {{ $psihologAnketum->behavior }}
                        </td>
                    </tr>
                </tbody>
            </table>
            <div class="form-group">
                <a class="btn btn-default" href="{{ route('admin.psiholog-anketa.index') }}">
                    {{ trans('global.back_to_list') }}
                </a>
            </div>
        </div>
    </div>
</div>



@endsection