@extends('layouts.admin')
@section('content')
    <div class="card">
        <div class="card-header">
            {{ trans('global.edit') }} {{ trans('cruds.schReport.title_singular') }}
        </div>

        <div class="card-body">
            <form method="POST" action="{{ route('admin.sch-reports.update', [$schReport->id]) }}"
                enctype="multipart/form-data">
                @method('PUT')
                @csrf
                <div class="form-group">
                    <label for="schclass_id">{{ trans('cruds.schReport.fields.schclass') }}</label>
                    <select class="form-control select2 {{ $errors->has('schclass') ? 'is-invalid' : '' }}" name="schclass_id"
                        id="schclass_id">
                        @foreach ($schclasses as $id => $entry)
                            <option value="{{ $id }}"
                                {{ (old('schclass_id') ? old('schclass_id') : $schReport->schclass->id ?? '') == $id ? 'selected' : '' }}>
                                {{ $entry }}</option>
                        @endforeach
                    </select>
                    @if ($errors->has('schclass'))
                        <div class="invalid-feedback">
                            {{ $errors->first('schclass') }}
                        </div>
                    @endif
                    <span class="help-block">{{ trans('cruds.schReport.fields.schclass_helper') }}</span>
                </div>
                <div class="form-group">
                    <label for="schstudent_id">{{ trans('cruds.schReport.fields.schstudent') }}</label>
                    <select class="form-control select2 {{ $errors->has('schstudent') ? 'is-invalid' : '' }}"
                        name="schstudent_id" id="schstudent_id">
                        @foreach ($schstudents as $id => $entry)
                            <option value="{{ $id }}"
                                {{ (old('schstudent_id') ? old('schstudent_id') : $schReport->schstudent->id ?? '') == $id ? 'selected' : '' }}>
                                {{ $entry }}</option>
                        @endforeach
                    </select>
                    @if ($errors->has('schstudent'))
                        <div class="invalid-feedback">
                            {{ $errors->first('schstudent') }}
                        </div>
                    @endif
                    <span class="help-block">{{ trans('cruds.schReport.fields.schstudent_helper') }}</span>
                </div>
                <div class="form-group">
                    <label for="schteacher_id">{{ trans('cruds.schReport.fields.schteacher') }}</label>
                    <select class="form-control select2 {{ $errors->has('schteacher') ? 'is-invalid' : '' }}"
                        name="schteacher_id" id="schteacher_id">
                        @foreach ($schteachers as $id => $entry)
                            <option value="{{ $id }}"
                                {{ (old('schteacher_id') ? old('schteacher_id') : $schReport->schteacher->id ?? '') == $id ? 'selected' : '' }}>
                                {{ $entry }}</option>
                        @endforeach
                    </select>
                    @if ($errors->has('schteacher'))
                        <div class="invalid-feedback">
                            {{ $errors->first('schteacher') }}
                        </div>
                    @endif
                    <span class="help-block">{{ trans('cruds.schReport.fields.schteacher_helper') }}</span>
                </div>
                <div class="form-group">
                    <label for="schsubject_id">{{ trans('cruds.schReport.fields.schsubject') }}</label>
                    <select class="form-control select2 {{ $errors->has('schsubject') ? 'is-invalid' : '' }}"
                        name="schsubject_id" id="schsubject_id">
                        @foreach ($schsubjects as $id => $entry)
                            <option value="{{ $id }}"
                                {{ (old('schsubject_id') ? old('schsubject_id') : $schReport->schsubject->id ?? '') == $id ? 'selected' : '' }}>
                                {{ $entry }}</option>
                        @endforeach
                    </select>
                    @if ($errors->has('schsubject'))
                        <div class="invalid-feedback">
                            {{ $errors->first('schsubject') }}
                        </div>
                    @endif
                    <span class="help-block">{{ trans('cruds.schReport.fields.schsubject_helper') }}</span>
                </div>
                <div class="form-group">
                    <label for="report">{{ trans('cruds.schReport.fields.report') }}</label>
                    <textarea class="form-control {{ $errors->has('report') ? 'is-invalid' : '' }}" name="report" id="report">{{ old('report', $schReport->report) }}</textarea>
                    @if ($errors->has('report'))
                        <div class="invalid-feedback">
                            {{ $errors->first('report') }}
                        </div>
                    @endif
                    <span class="help-block">{{ trans('cruds.schReport.fields.report_helper') }}</span>
                </div>
                <div class="form-group">
                    <label for="report_en">{{ trans('cruds.schReport.fields.report_en') }}</label>
                    <textarea class="form-control {{ $errors->has('report_en') ? 'is-invalid' : '' }}" name="report_en" id="report_en">{{ old('report_en', $schReport->report_en) }}</textarea>
                    @if ($errors->has('report_en'))
                        <div class="invalid-feedback">
                            {{ $errors->first('report_en') }}
                        </div>
                    @endif
                    <span class="help-block">{{ trans('cruds.schReport.fields.report_en_helper') }}</span>
                </div>
                <div class="form-group">
                    <button class="btn btn-danger" type="submit">
                        {{ trans('global.save') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
@endsection
