@extends('layouts.admin')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.edit') }} {{ trans('cruds.schstudent.title_singular') }}
    </div>

    <div class="card-body">
        <form method="POST" action="{{ route("admin.schstudents.update", [$schstudent->id]) }}" enctype="multipart/form-data">
            @method('PUT')
            @csrf
            <div class="form-group">
                <label for="name_ua">{{ trans('cruds.schstudent.fields.name_ua') }}</label>
                <input class="form-control {{ $errors->has('name_ua') ? 'is-invalid' : '' }}" type="text" name="name_ua" id="name_ua" value="{{ old('name_ua', $schstudent->name_ua) }}">
                @if($errors->has('name_ua'))
                    <div class="invalid-feedback">
                        {{ $errors->first('name_ua') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.schstudent.fields.name_ua_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="name_en">{{ trans('cruds.schstudent.fields.name_en') }}</label>
                <input class="form-control {{ $errors->has('name_en') ? 'is-invalid' : '' }}" type="text" name="name_en" id="name_en" value="{{ old('name_en', $schstudent->name_en) }}">
                @if($errors->has('name_en'))
                    <div class="invalid-feedback">
                        {{ $errors->first('name_en') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.schstudent.fields.name_en_helper') }}</span>
            </div>
            <div class="form-group">
                <label for="userid">{{ trans('cruds.schstudent.fields.userid') }}</label>
                <input class="form-control {{ $errors->has('userid') ? 'is-invalid' : '' }}" type="text" name="userid" id="userid" value="{{ old('userid', $schstudent->userid) }}">
                @if($errors->has('userid'))
                    <div class="invalid-feedback">
                        {{ $errors->first('userid') }}
                    </div>
                @endif
                <span class="help-block">{{ trans('cruds.schstudent.fields.userid_helper') }}</span>
            </div>
            <div class="form-group">
                <button class="btn btn-danger" type="submit">
                    {{ trans('global.save') }}
                </button>
            </div>
        </form>
    </div>
</div>



@endsection