@extends('layouts.admin')
@section('content')
@can('schstudent_create')
    <div style="margin-bottom: 10px;" class="row">
        <div class="col-lg-12">
            <a class="btn btn-success" href="{{ route('admin.schstudents.create') }}">
                {{ trans('global.add') }} {{ trans('cruds.schstudent.title_singular') }}
            </a>
            <button class="btn btn-warning" data-toggle="modal" data-target="#csvImportModal">
                {{ trans('global.app_csvImport') }}
            </button>
            @include('csvImport.modal', ['model' => 'Schstudent', 'route' => 'admin.schstudents.parseCsvImport'])
        </div>
    </div>
@endcan
<div class="card">
    <div class="card-header">
        {{ trans('cruds.schstudent.title_singular') }} {{ trans('global.list') }}
    </div>

    <div class="card-body">
        <div class="table-responsive">
            <table class=" table table-bordered table-striped table-hover datatable datatable-Schstudent">
                <thead>
                    <tr>
                        <th width="10">

                        </th>
                        <th>
                            {{ trans('cruds.schstudent.fields.id') }}
                        </th>
                        <th>
                            {{ trans('cruds.schstudent.fields.name_ua') }}
                        </th>
                        <th>
                            {{ trans('cruds.schstudent.fields.name_en') }}
                        </th>
                        <th>
                            {{ trans('cruds.schstudent.fields.userid') }}
                        </th>
                        <th>
                            &nbsp;
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($schstudents as $key => $schstudent)
                        <tr data-entry-id="{{ $schstudent->id }}">
                            <td>

                            </td>
                            <td>
                                {{ $schstudent->id ?? '' }}
                            </td>
                            <td>
                                {{ $schstudent->name_ua ?? '' }}
                            </td>
                            <td>
                                {{ $schstudent->name_en ?? '' }}
                            </td>
                            <td>
                                {{ $schstudent->userid ?? '' }}
                            </td>
                            <td>
                                @can('schstudent_show')
                                    <a class="btn btn-xs btn-primary" href="{{ route('admin.schstudents.show', $schstudent->id) }}">
                                        {{ trans('global.view') }}
                                    </a>
                                @endcan

                                @can('schstudent_edit')
                                    <a class="btn btn-xs btn-info" href="{{ route('admin.schstudents.edit', $schstudent->id) }}">
                                        {{ trans('global.edit') }}
                                    </a>
                                @endcan

                                @can('schstudent_delete')
                                    <form action="{{ route('admin.schstudents.destroy', $schstudent->id) }}" method="POST" onsubmit="return confirm('{{ trans('global.areYouSure') }}');" style="display: inline-block;">
                                        <input type="hidden" name="_method" value="DELETE">
                                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                        <input type="submit" class="btn btn-xs btn-danger" value="{{ trans('global.delete') }}">
                                    </form>
                                @endcan

                            </td>

                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>



@endsection
@section('scripts')
@parent
<script>
    $(function () {
  let dtButtons = $.extend(true, [], $.fn.dataTable.defaults.buttons)
@can('schstudent_delete')
  let deleteButtonTrans = '{{ trans('global.datatables.delete') }}'
  let deleteButton = {
    text: deleteButtonTrans,
    url: "{{ route('admin.schstudents.massDestroy') }}",
    className: 'btn-danger',
    action: function (e, dt, node, config) {
      var ids = $.map(dt.rows({ selected: true }).nodes(), function (entry) {
          return $(entry).data('entry-id')
      });

      if (ids.length === 0) {
        alert('{{ trans('global.datatables.zero_selected') }}')

        return
      }

      if (confirm('{{ trans('global.areYouSure') }}')) {
        $.ajax({
          headers: {'x-csrf-token': _token},
          method: 'POST',
          url: config.url,
          data: { ids: ids, _method: 'DELETE' }})
          .done(function () { location.reload() })
      }
    }
  }
  dtButtons.push(deleteButton)
@endcan

  $.extend(true, $.fn.dataTable.defaults, {
    orderCellsTop: true,
    order: [[ 1, 'desc' ]],
    pageLength: 100,
  });
  let table = $('.datatable-Schstudent:not(.ajaxTable)').DataTable({ buttons: dtButtons })
  $('a[data-toggle="tab"]').on('shown.bs.tab click', function(e){
      $($.fn.dataTable.tables(true)).DataTable()
          .columns.adjust();
  });
  
})

</script>
@endsection