@extends('layouts.admin')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.show') }} {{ trans('cruds.schstudent.title') }}
    </div>

    <div class="card-body">
        <div class="form-group">
            <div class="form-group">
                <a class="btn btn-default" href="{{ route('admin.schstudents.index') }}">
                    {{ trans('global.back_to_list') }}
                </a>
            </div>
            <table class="table table-bordered table-striped">
                <tbody>
                    <tr>
                        <th>
                            {{ trans('cruds.schstudent.fields.id') }}
                        </th>
                        <td>
                            {{ $schstudent->id }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.schstudent.fields.name_ua') }}
                        </th>
                        <td>
                            {{ $schstudent->name_ua }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.schstudent.fields.name_en') }}
                        </th>
                        <td>
                            {{ $schstudent->name_en }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.schstudent.fields.userid') }}
                        </th>
                        <td>
                            {{ $schstudent->userid }}
                        </td>
                    </tr>
                </tbody>
            </table>
            <div class="form-group">
                <a class="btn btn-default" href="{{ route('admin.schstudents.index') }}">
                    {{ trans('global.back_to_list') }}
                </a>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        {{ trans('global.relatedData') }}
    </div>
    <ul class="nav nav-tabs" role="tablist" id="relationship-tabs">
        <li class="nav-item">
            <a class="nav-link" href="#schstudent_sch_reports" role="tab" data-toggle="tab">
                {{ trans('cruds.schReport.title') }}
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link" href="#schstudent_sch_classes" role="tab" data-toggle="tab">
                {{ trans('cruds.schClass.title') }}
            </a>
        </li>
    </ul>
    <div class="tab-content">
        <div class="tab-pane" role="tabpanel" id="schstudent_sch_reports">
            @includeIf('admin.schstudents.relationships.schstudentSchReports', ['schReports' => $schstudent->schstudentSchReports])
        </div>
        <div class="tab-pane" role="tabpanel" id="schstudent_sch_classes">
            @includeIf('admin.schstudents.relationships.schstudentSchClasses', ['schClasses' => $schstudent->schstudentSchClasses])
        </div>
    </div>
</div>

@endsection