<?php

Route::redirect('/', '/login');
Route::get('/home', function () {
    if (session('status')) {
        return redirect()->route('admin.home')->with('status', session('status'));
    }

    return redirect()->route('admin.home');
});

Auth::routes(['register' => false]);

Route::group(['prefix' => 'admin', 'as' => 'admin.', 'namespace' => 'Admin', 'middleware' => ['auth']], function () {
    Route::get('/', 'HomeController@index')->name('home');
    // Permissions
    Route::delete('permissions/destroy', 'PermissionsController@massDestroy')->name('permissions.massDestroy');
    Route::resource('permissions', 'PermissionsController');

    // Roles
    Route::delete('roles/destroy', 'RolesController@massDestroy')->name('roles.massDestroy');
    Route::resource('roles', 'RolesController');

    // Users
    Route::delete('users/destroy', 'UsersController@massDestroy')->name('users.massDestroy');
    Route::post('users/parse-csv-import', 'UsersController@parseCsvImport')->name('users.parseCsvImport');
    Route::post('users/process-csv-import', 'UsersController@processCsvImport')->name('users.processCsvImport');
    Route::resource('users', 'UsersController');

    // Crm Status
    Route::delete('crm-statuses/destroy', 'CrmStatusController@massDestroy')->name('crm-statuses.massDestroy');
    Route::resource('crm-statuses', 'CrmStatusController');

    // Crm Customer
    Route::delete('crm-customers/destroy', 'CrmCustomerController@massDestroy')->name('crm-customers.massDestroy');
    Route::post('crm-customers/parse-csv-import', 'CrmCustomerController@parseCsvImport')->name('crm-customers.parseCsvImport');
    Route::post('crm-customers/process-csv-import', 'CrmCustomerController@processCsvImport')->name('crm-customers.processCsvImport');
    Route::resource('crm-customers', 'CrmCustomerController');

    // Crm Note
    Route::delete('crm-notes/destroy', 'CrmNoteController@massDestroy')->name('crm-notes.massDestroy');
    Route::resource('crm-notes', 'CrmNoteController');

    // Crm Document
    Route::delete('crm-documents/destroy', 'CrmDocumentController@massDestroy')->name('crm-documents.massDestroy');
    Route::post('crm-documents/media', 'CrmDocumentController@storeMedia')->name('crm-documents.storeMedia');
    Route::post('crm-documents/ckmedia', 'CrmDocumentController@storeCKEditorImages')->name('crm-documents.storeCKEditorImages');
    Route::resource('crm-documents', 'CrmDocumentController');

    // Psiholog Anketa
    Route::delete('psiholog-anketa/destroy', 'PsihologAnketaController@massDestroy')->name('psiholog-anketa.massDestroy');
    Route::post('psiholog-anketa/parse-csv-import', 'PsihologAnketaController@parseCsvImport')->name('psiholog-anketa.parseCsvImport');
    Route::post('psiholog-anketa/process-csv-import', 'PsihologAnketaController@processCsvImport')->name('psiholog-anketa.processCsvImport');
    Route::resource('psiholog-anketa', 'PsihologAnketaController');

    // Schstudent
    Route::delete('schstudents/destroy', 'SchstudentController@massDestroy')->name('schstudents.massDestroy');
    Route::post('schstudents/parse-csv-import', 'SchstudentController@parseCsvImport')->name('schstudents.parseCsvImport');
    Route::post('schstudents/process-csv-import', 'SchstudentController@processCsvImport')->name('schstudents.processCsvImport');
    Route::resource('schstudents', 'SchstudentController');

    // Sch Class
    Route::delete('sch-classes/destroy', 'SchClassController@massDestroy')->name('sch-classes.massDestroy');
    Route::post('sch-classes/parse-csv-import', 'SchClassController@parseCsvImport')->name('sch-classes.parseCsvImport');
    Route::post('sch-classes/process-csv-import', 'SchClassController@processCsvImport')->name('sch-classes.processCsvImport');
    Route::resource('sch-classes', 'SchClassController');

    // Sch Teacher
    Route::delete('sch-teachers/destroy', 'SchTeacherController@massDestroy')->name('sch-teachers.massDestroy');
    Route::post('sch-teachers/parse-csv-import', 'SchTeacherController@parseCsvImport')->name('sch-teachers.parseCsvImport');
    Route::post('sch-teachers/process-csv-import', 'SchTeacherController@processCsvImport')->name('sch-teachers.processCsvImport');
    Route::resource('sch-teachers', 'SchTeacherController');

    // Sch Report
    Route::delete('sch-reports/destroy', 'SchReportController@massDestroy')->name('sch-reports.massDestroy');
    Route::post('sch-reports/parse-csv-import', 'SchReportController@parseCsvImport')->name('sch-reports.parseCsvImport');
    Route::post('sch-reports/process-csv-import', 'SchReportController@processCsvImport')->name('sch-reports.processCsvImport');
    Route::resource('sch-reports', 'SchReportController');



    // Sch Report - Get Class Data
    Route::get('class-list/get-class-data', [App\Http\Controllers\Admin\SchReportController::class, 'getClassData']);

    // filepath: routes/web.php
    Route::get('class-list', [App\Http\Controllers\Admin\SchReportController::class, 'classList'])
        ->name('sch-reports.classList');

    // Sch Report - Student Reports
    /* Route::get('class-list/student-reports', [App\Http\Controllers\Admin\SchReportController::class, 'studentReports'])->name('admin.sch-reports.studentReports'); */

    Route::get('class-list/student-reports', [App\Http\Controllers\Admin\SchReportController::class, 'studentReports'])->name('admin.sch-reports.studentReports');
    Route::post('sch-reports/store', [App\Http\Controllers\Admin\SchReportController::class, 'store'])->name('admin.sch-reports.store');

    Route::delete('sch-reports/{schReport}', 'SchReportController@destroy')->name('admin.sch-reports.destroy');
    Route::put('sch-reports/{schReport}', 'SchReportController@update')->name('admin.sch-reports.update');

    // Sch Report AND

    // Sch Subject
    Route::delete('sch-subjects/destroy', 'SchSubjectController@massDestroy')->name('sch-subjects.massDestroy');
    Route::post('sch-subjects/parse-csv-import', 'SchSubjectController@parseCsvImport')->name('sch-subjects.parseCsvImport');
    Route::post('sch-subjects/process-csv-import', 'SchSubjectController@processCsvImport')->name('sch-subjects.processCsvImport');
    Route::resource('sch-subjects', 'SchSubjectController');
});
Route::group(['prefix' => 'profile', 'as' => 'profile.', 'namespace' => 'Auth', 'middleware' => ['auth']], function () {
    // Change password
    if (file_exists(app_path('Http/Controllers/Auth/ChangePasswordController.php'))) {
        Route::get('password', 'ChangePasswordController@edit')->name('password.edit');
        Route::post('password', 'ChangePasswordController@update')->name('password.update');
        Route::post('profile', 'ChangePasswordController@updateProfile')->name('password.updateProfile');
        Route::post('profile/destroy', 'ChangePasswordController@destroy')->name('password.destroyProfile');
    }
});
